package com.example.jfiggins.publish_listview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.HashMap;

public class MyAdapter extends BaseAdapter {
    private final Context context;
    private final ArrayList<MyAdapterRow> rowList;
    private final HashMap<Integer, Drawable> images;
    private final LayoutInflater layoutInflater;
    private ViewHolder viewHolder;

    public MyAdapter(Context context, ArrayList<MyAdapterRow> rowList) {
        this.context = context;
        this.rowList = rowList;
        images = new HashMap<>();
        layoutInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    @Override
    public int getCount() {
        return rowList.size()*10;
    }

    @Override
    public Object getItem(int position) {
        return rowList.get(position%rowList.size());
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    private Drawable getDrawable(int resId) {
        Drawable drawable = images.get(resId);
        if(drawable == null) {
            drawable = context.getResources().getDrawable(resId);
            images.put(resId, drawable);
        }
        return drawable;
    }

    @Override
    public View getView(int position, View view, ViewGroup parent) {
        if(view == null) {
            view = layoutInflater.inflate(R.layout.listview_row, parent, false);
            viewHolder = new ViewHolder();
            viewHolder.textView = (TextView) view.findViewById(R.id.textView);
            viewHolder.imageView = (ImageView) view.findViewById(R.id.imageView);
            view.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) view.getTag();
        }

        viewHolder.textView.setText(((MyAdapterRow) getItem(position)).text);
        viewHolder.imageView.setImageDrawable(getDrawable(((MyAdapterRow) getItem(position)).resId));
        return view;
    }

}

class ViewHolder {
    public ImageView imageView;
    public TextView textView;
}

class MyAdapterRow {

    public MyAdapterRow(int resId, String text) {
        this.resId = resId;
        this.text = text;
    }

    public int resId;
    public String text;

}

